/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.VWPropertyMenuItem;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.design.property.steps.VWMapSelectionPanel;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class VWSubmapStepGeneralTab
extends JPanel
implements IVWPropertyTab,
DocumentListener,
IVWPropertyChangeSource {
    private VWCompoundStepDefinition m_stepDefinition = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private Vector m_changedItems = null;
    protected JTextField m_nameTextField = null;
    private VWMapSelectionPanel m_mapSelectionPanel = null;

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.createControls();
            this.setSelectedStep(vwMapNode);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedStep(VWMapNode vwMapNode) {
        block7: {
            if (vwMapNode == null || vwMapNode == this.m_stepDefinition) {
                return;
            }
            this.m_stepDefinition = (VWCompoundStepDefinition)vwMapNode;
            try {
                this.m_nameTextField.getDocument().removeDocumentListener(this);
                this.m_nameTextField.setText("");
                if (this.m_stepDefinition == null) break block7;
                this.m_nameTextField.setText(this.getDisplayName());
                VWInstructionDefinition[] instructionDefs = this.m_stepDefinition.getInstructions();
                if (instructionDefs == null || this.m_mapSelectionPanel == null) break block7;
                for (int i = 0; i < instructionDefs.length; ++i) {
                    if (instructionDefs[i].getAction() != 5) continue;
                    this.m_mapSelectionPanel.setInstructionDefinition(instructionDefs[i]);
                    break;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            finally {
                this.m_nameTextField.getDocument().addDocumentListener(this);
            }
        }
    }

    public void releaseReferences() {
        if (this.m_nameTextField != null) {
            this.m_nameTextField.getDocument().removeDocumentListener(this);
            this.m_nameTextField = null;
        }
        if (this.m_mapSelectionPanel != null) {
            this.m_mapSelectionPanel.releaseReferences();
            this.m_mapSelectionPanel = null;
        }
        this.m_authPropertyData = null;
        this.m_stepDefinition = null;
        this.removeAll();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void notifyPropertyChange() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 501);
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 10);
            this.add((Component)this.getNamePanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_mapSelectionPanel = new VWMapSelectionPanel(this.m_authPropertyData);
            this.add((Component)this.m_mapSelectionPanel, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            this.add((Component)new JLabel(" "), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel getNamePanel() {
        try {
            VWToolbarBorder stepNameBorder = new VWToolbarBorder(VWResource.s_stepNameStr);
            JPanel childPanel = stepNameBorder.getClientPanel();
            childPanel.setLayout(new BorderLayout(6, 6));
            this.m_nameTextField = new JTextField("", 15);
            this.m_nameTextField.getDocument().addDocumentListener(this);
            childPanel.add((Component)this.m_nameTextField, "First");
            return stepNameBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected String getDisplayName() {
        if (this.m_stepDefinition != null) {
            return VWPropertyMenuItem.getDisplayName(this.m_stepDefinition);
        }
        return null;
    }

    private void handleDocumentEvent(DocumentEvent event) {
        if (this.m_stepDefinition == null) {
            return;
        }
        if (event.getDocument() == this.m_nameTextField.getDocument()) {
            this.updateName();
        }
    }

    private void updateName() {
        try {
            if (this.m_stepDefinition != null && this.m_nameTextField != null) {
                String name = this.m_nameTextField.getText();
                String blankName = VWPropertyMenuItem.getBlankName(this.m_stepDefinition);
                if ((name.length() == 0 || name.equals(blankName)) && this.m_stepDefinition.getName() == null) {
                    return;
                }
                this.m_stepDefinition.setName(name);
                this.m_authPropertyData.setDirty();
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(this.m_stepDefinition);
                this.notifyPropertyChange();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

